/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;


public class ProgressBar extends Control {
	int minimum = 0, maximum = 100, selection = 0;

public ProgressBar (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
}

void createWidget (Display display, Widget parent, int style, int index) {
	super.createWidget (display, parent, style, index);
	this.setValues(selection, minimum, maximum);
}

public int getMaximum () {
	checkWidget ();
	return maximum;
}

public int getMinimum () {
	checkWidget ();
	return minimum;
}

public int getSelection () {
	checkWidget ();
	return selection;
}

public void setMaximum (int value) {
	setValues(selection, minimum, value);
}

public void setMinimum (int value) {
	setValues(selection, value, maximum);
}

public void setSelection (int value) {
	setValues(value, minimum, maximum);
}

void setValues (int selection, int minimum, int maximum) {
	checkWidget ();
	if (maximum <= minimum) return;
	selection = Math.min (Math.max (minimum, selection), maximum);
	this.selection = selection;
	this.minimum = minimum;
	this.maximum = maximum;
	_setValues (selection, minimum, maximum);
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if((style & (@org.eclipse.swt.SWT::VERTICAL)) == 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.HorizontalProgressBar"]){
			$wnd.dojo._hasResource["org.eclipse.swt.HorizontalProgressBar"] = true;
			$wnd.dojo.provide("org.eclipse.swt.HorizontalProgressBar");
			
			$wnd.dojo.require("dijit.ProgressBar");
		
			$wnd.dojo.declare("org.eclipse.swt.HorizontalProgressBar", $wnd.dijit.ProgressBar, {
				border: "",
				templateString:
					'<div class="dijitProgressBar dijitProgressBarEmpty">' +
						'<div waiRole="progressbar" tabindex="0" dojoAttachPoint="internalProgress" class="dijitProgressBarFull">' +
							'<div class="dijitProgressBarTile"></div>' +
						'</div>' +
						'<img dojoAttachPoint="inteterminateHighContrastImage" class="dijitProgressBarIndeterminateHighContrastImage"></img>' +
					'</div>',
				postCreate: function(){
					this.inherited("postCreate",arguments); 
					$wnd.dojo.addClass(this.domNode, "swtHorizontalProgressBar");
					$wnd.swt.setCssStyle(this.domNode, {border: this.border});
				},
				resize: function(dim){},
				update: function(attributes) {
					if(attributes){
						$wnd.dojo.mixin(this, attributes);
						if(this.indeterminate){
							$wnd.dojo.addClass(this.domNode, "dijitProgressBarIndeterminate");
						} else {						
							$wnd.dojo.removeClass(this.domNode, "dijitProgressBarIndeterminate");
							this.internalProgress.style.width = ((this.progress-this.minimum) * (100/(this.maximum-this.minimum))) + "%";
						}
						this.onChange();
					}
				}
			});
		}
	}
	if((style & (@org.eclipse.swt.SWT::VERTICAL)) != 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.VerticalProgressBar"]){
			$wnd.dojo._hasResource["org.eclipse.swt.VerticalProgressBar"] = true;
			$wnd.dojo.provide("org.eclipse.swt.VerticalProgressBar");
			
			$wnd.dojo.require("dijit.ProgressBar");
		
			$wnd.dojo.declare("org.eclipse.swt.VerticalProgressBar", $wnd.dijit.ProgressBar, {
				border: "",
				templateString:
					'<div class="dijitProgressBar dijitProgressBarEmpty">' +
						'<div waiRole="progressbar" tabindex="0" dojoAttachPoint="internalProgress" class="dijitProgressBarFull">' +
							'<div class="dijitProgressBarTile"></div>' +
						'</div>' +
						'<img dojoAttachPoint="inteterminateHighContrastImage" class="dijitProgressBarIndeterminateHighContrastImage"></img>' +
					'</div>',
				postCreate: function(){
					this.inherited("postCreate",arguments); 
					$wnd.swt.setCssStyle(this.domNode, {border: this.border});
					$wnd.swt.setCssStyle(this.internalProgress, {
						bottom: 0,
						top: "auto"
					});
					$wnd.dojo.addClass(this.domNode, "swtVerticalProgressBar");
				},
				resize: function(dim){},
				update: function(attributes) {
					if(attributes){
						$wnd.dojo.mixin(this, attributes);
						if(this.indeterminate){
							$wnd.dojo.addClass(this.domNode, "dijitProgressBarIndeterminate");
						} else {						
							$wnd.dojo.removeClass(this.domNode, "dijitProgressBarIndeterminate");
							this.internalProgress.style.height = ((this.progress-this.minimum) * (100/(this.maximum-this.minimum))) + "%";
						}
						this.onChange();
					}
				}
			});
		}
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	if((style & (@org.eclipse.swt.SWT::INDETERMINATE)) != 0){
		params.indeterminate = true;
	}
	if((style & (@org.eclipse.swt.SWT::SMOOTH)) != 0){
	}
	if((style & (@org.eclipse.swt.SWT::VERTICAL)) == 0){
		var self = new $wnd.org.eclipse.swt.HorizontalProgressBar(params);        	
	} 
	if((style & (@org.eclipse.swt.SWT::VERTICAL)) != 0){
		var self = new $wnd.org.eclipse.swt.VerticalProgressBar(params);
	}
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _setValues (int selection, int minimum, int maximum) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.update({
		minimum: minimum, 
		maximum: maximum,
		progress: selection
	});
}-*/;
}
